;
; Virtual Disk Drive Project	- August 7, 2001 - EJR (in Hawaii)
;				- Aug 27 - EJR - Update to have clock byte
;				- Sep 27, 2002 - on plane
 
#include "vd.h"
#include "utility.h"
#include "disk.h"
#include "serbyte.mac"
#include "headmove.mac"
#include "waitP2.mac"
#include "write.mac"

	global	SByte		; serialize a byte out with adj clocking sig
	global	SByteSimple	; serialize a byte out

	global	DD0x4e		; generates a DD 0x4e (does auto-increment too)
        global	DD0x00		; generates a DD 0x00
	global  DD0xa1S		; generates the special DD 0x41 (missing transition)

        global  SD0xff		; generates a SD 0xff (does auto-increment too)
        global  SD0x00		; generates a SD 0x00

;;; 20 MHz version
;;;   - this is currently written for 8us between clock pulses, or
;;;     or 40 instruction cycles at 20MHz (each clock is 50ns, and
;;;	each instruction is 4 cycles, so 200ns per instruction)
;;;   - Pulse widths are 5 instructions, or 1us.
;;;
;;; NOTE - THIS DIAGRAM IS OLD AND NOT ACCURATE
;;; 
;;;     _2_    	       	      ___		    ___
;;; ___|   |________15_______|   |_______15________|   |________
;;;
;;;    ^   ^                 ^   ^                 ^
;;;    0   4                20  24                40

;;; =======================================================================
;;; === All of this code is called by sector generation routines, which
;;; === reside in page 2 of program memory...so all of these are in page2.
;;; =======================================================================
	
PROG2		CODE

;;;*******************************************************************
;;; NAME:	SByte()
;;;
;;; DESCR:	Writes a byte out with the given special clock.
;;;
;;; ARGS:	ARG1 = has the byte to write out, it is munged upon return
;;;		ARG2 = the clock byte to shift out.  Normally this would be
;;;                    0xff for a standard full clock.  Some bytes in the
;;;                    floppy headers need to have other clock values.  Just
;;;		       like with ARG1, this thing must be left-aligned.
;;;		       ARG2 is munged upon return
;;;
;;; RETURNS:	nothing returned
;;;		when it comes back, there are 11 cycles left before the
;;;		start of the next clock bit should come out.
;;;
;;; NOTES:	- SBWORK is used
;;;		- this thing works by generating the first bit, setting
;;;		  up for the next 6 bits, then doing the last bit.  This
;;;		  eaks out a few extra clocks at the end of the routine.
;;;		- the first clock pulse (if necessary) comes out on the
;;;		  third instruction.
;;;		- BIG NOTE - sometimes a skip is done before a BitPulse
;;;		  This has the effect of skipping the "Raise RDATA" in
;;;		  the BitPulse macro.
;;;*******************************************************************

SByte:
		rlf	ARG2		; (-2) get first clock bit into carry
		skpnc			; (-1) if no carry, don't do clock bit
		BitPulse		; (0)

	;; 13 total cycle delay 'tween clock and data

		Wait11			; (-13)

		rlf	ARG1		; (-2) carry bit out
		skpnc			; (-1)
		BitPulse		; (0)

		movlw	D'6'		; (-13) prepare for more bits
		movwf	SBWORK		; (-12)

		Wait9			; (-11)

SByte1:
		rlf	ARG2		; (-2) check for clock bit
		skpnc			; (-1)
		BitPulse		; (0)

		Wait11			; (-13)

		rlf	ARG1		; (-2) carry bit out
		skpnc			; (-1)
		BitPulse

		decfsz	SBWORK		; (-13) done with 7th bit?
		goto	SByte2		; (-12) nope, need to go on
		goto	SByte3		; (-11) done with 7 bits

SByte2:		Wait6			; (-10) allow time for next bit
		goto	SByte1		; (-4)

SByte3:		Wait7			; (-9) do last bit now
		rlf	ARG2		; (-2) check for clock bit
		skpnc			; (-1)
		BitPulse		; (0)

		Wait11			; (-13)

		rlf	ARG1		; (-2) put out last bit if necessary
		skpnc			; (-1)
		BitPulse		; (0)

		return			; (-13)

	
;;;*******************************************************************
;;; NAME:	SByteSimple()
;;;
;;; DESCR:	Writes a simple byte out with a normal clock.  The clock
;;;		pulse goes high on the first instruction.
;;;
;;; ARGS:	ARG1 has the byte to write out, it is munged upon return
;;;
;;; RETURNS:	nothing returned
;;;		when it comes back, there are 11 cycles left before the
;;;		start of the next clock bit should come out.
;;;
;;; NOTES:	- SBWORK is used
;;;		- this thing works by generating the first bit, setting
;;;		  up for the next 6 bits, then doing the last bit.  This
;;;		  eaks out a few extra clocks at the end of the routine.
;;;		- the first clock pulse comes out on the first instruction.
;;;*******************************************************************

SByteSimple:
		BitPulse		; (0)

		Wait11			; (-13)

		rlf	ARG1		; (-2) carry bit out
		skpnc			; (-1)
		BitPulse

		movlw	D'6'		; (-13) prepare for more bits
		movwf	SBWORK		; (-12)

		Wait11			; (-11)
	
SByteSimple1:
		BitPulse		; (0)

		Wait11			; (-13)

		rlf	ARG1		; (-2) carry bit out
		skpnc			; (-1)
		BitPulse		; (0)

		decfsz	SBWORK		; (-13) done with 7th bit?
		goto	SByteSimple2	; (-12) nope, need to go on
		goto	SByteSimple3	; (-11) done with 7 bits

SByteSimple2:	Wait8			; (-10) allow time for next bit
		goto	SByteSimple1	; (-2)

SByteSimple3:	Wait9			; (-9) do last bit now
		BitPulse		; (0)

		Wait11			; (-13)

		rlf	ARG1		; (-2) put out last bit if necessary
		skpnc			; (-1)
		BitPulse		; (0)

		return			; (-13)

;;;*******************************************************************
;;; NAME:	CheckWriteGate() MACRO
;;;
;;; DESCR:	Used within DD0x4e() and SD0xff() to check for a
;;;		write condition.  If a write is noticed, then this
;;;		routine returns immediately.  The caller needs to
;;;		recheck the condition to find out if the routine
;;;		returned because of write, or just normal return.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************

CheckWriteGate:	macro
		SkipIfLow	WRITE_GATE	; (0) if not writing 2-hop past the return
		SkipIfWriteEnabled		; (1) if writing, and enabled, skip to return
		SkipAlways			; (2) 
		return				; (3)	
		endm				; (4) 

;;;*******************************************************************
;;; NAME:	SD0xff()
;;;
;;; DESCR:	Does the ARG0 count of 0xff's in SD.  Also aligns
;;;		memory if INCVAR is specified right.
;;;
;;; ARGS:	ARG0 has the number of 0xff's to do
;;;		SBWORK is used
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- does 15, count 'em, 15 align increments per byte
;;;		- call at (-4), and returns at (-9)
;;;		- if 0 is given in ARG0, that's interpreted as 256
;;;		- NOTE that the write gate is only checked at the
;;;		  last bit of a byte...this means that we'll miss at least
;;;		  a whole byte of write-gate introduced 0x00's that
;;;		  are sent on WDATA.  Since, however, there are 6 of
;;;		  them, we should be OK.
;;;		- it is IMPORTANT that a number of 0xff's be generated
;;;		  for the data gap that is ONE MORE than that which
;;;		  triggers the write gate.  Otherwise, we may miss it.
;;;*******************************************************************
SD0xff:
		movlw	d'15'		; (-2)
		movwf	SBWORK		; (-1)

SD0xff_1:	BitPulse		; (0)
		CondMemIncLow		; (-13)
		Wait2			; (-7)
		HeadCheck		; (-5)
		decfsz	SBWORK		; (-3)
		goto	SD0xff_1	; (-2)

		Wait1			; (-1)
		BitPulse		; (0) 16th bit is done outside of loop
		decf	ARG0		; (-13)
		skpnz			; (-12)
		return			; (-11)

		CheckWriteGate		; (-10) only checks on the last bit of the byte
		Wait2			; (-6)
		goto	SD0xff		; (-4)

;;;*******************************************************************
;;; NAME:	SD0x00()
;;;
;;; DESCR:	Does the ARG0 count of 0x00's in SD.
;;;
;;; ARGS:	ARG0 has the number of 0x00's to do
;;;		SBWORK is used
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- call at (-2), and returns at (-9)
;;;		- does 12 align increments per byte potentially
;;;		- checks for the write gate going up (used in H17)
;;;*******************************************************************
SD0x00:
		BitPulse		; (0) first bit outside loop
		Wait13			; (-13)
		Wait18			; (-20) here's where a bit COULD be
	
		movlw	d'6'		; (-2) prepare for remaining bits
		movwf	SBWORK		; (-1)

SD0x00_1:	BitPulse		; (0)
		CondMemIncLow		; (-13)
		Wait7			; (-7)
		CondMemIncLow		; (-20) here's where a bit COULD be
		Wait11			; (-14) but not for a zero
		decfsz	SBWORK		; (-3)
		goto	SD0x00_1	; (-2)

		Wait1			; (-1)
		BitPulse		; (0) last bit
		Wait13			; (-13)
		Wait7			; (-20) again, no bit here
		decf	ARG0		; (-13)
		skpnz			; (-12)
		return			; (-11)

		CheckWriteGate		; (-10)
		Wait4			; (-6)
		goto	SD0x00		; (-2)

;;;*******************************************************************
;;; NAME:	DD4e()
;;;
;;; DESCR:	Generate the given count of 0x4e's in DD mode.
;;;		This is done BY HAND so that increments can be done.
;;;		upon entry into this routine, the last bit is checked
;;;		to ensure that our timing is on...and upon exit the
;;;		last bit is set to a zero.
;;;
;;; ARGS:	ARG0 is the number of bytes to do
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- 0x4e = 01001110 = 10,01,00,10,01,01,01,00
;;;		- "call" this routine at (-4), returns at (-16)
;;;		- increments memory up to 8 times
;;;			(this means that INCVAR must be set right)
;;;		- note that there are many headchecks thrown in to make
;;;		  sure that we don't miss head-move pulses
;;;*******************************************************************

	
DD0x4e:
		Wait1			; (-2)
		btfss	STATUS,C	; (-1) last bit was a one
DD0x4e_1:	BitPulse		; (0) last bit was a zero
		CondMemIncLow		; (-23)
		HeadCheck		; (-17)
		CondMemIncLow		; (-15)
		HeadCheck		; (-9)
		CheckWriteGate		; (-7)
		Wait3			; (-3) With the HeadChecks and Incs and Wait = Wait23
	
		BitPulse		; (0)
		CondMemIncLow		; (-23)
		HeadCheck		; (-17)
		CondMemIncLow		; (-15)
		HeadCheck		; (-9)
		CheckWriteGate		; (-7)
		Wait3			; (-3) With the HeadChecks and Incs and Wait = Wait23
	
		BitPulse		; (-0)
		CondMemIncLow		; (-23)
		HeadCheck		; (-17)
		CondMemIncLow		; (-15)
		HeadCheck		; (-9)
		CheckWriteGate		; (-7)
		Wait3			; (-3) With the HeadChecks and Incs and Wait = Wait23

		BitPulse		; (0)
		CondMemIncLow		; (-13)
		HeadCheck		; (-7)
		CheckWriteGate		; (-5)
		Wait1			; (-1) With the HeadChecks and Incs and Wait = Wait13
	
		BitPulse		; (-0)
		CondMemIncLow		; (-13)
		HeadCheck		; (-7)
		CheckWriteGate		; (-5)
		Wait1			; (-1) With the HeadChecks and Incs and Wait = Wait13

		BitPulse		; (-0)

		decfsz	ARG0		; (-23)
		goto	DD0x4e_2	; (-22)

		bcf	STATUS,C	; (-21) last bit was a zero
		return			; (-20) on a zero cycle

DD0x4e_2:	Wait8			; (-20)
		CheckWriteGate		; (-12)
		Wait6			; (-8)
		goto	DD0x4e_1	; (-2)

;;;*******************************************************************
;;; NAME:	DD0x00()
;;;
;;; DESCR:	Generate a sequence of 0x00's.
;;;
;;; ARGS:	ARG0 holds the number of 0x00's to generate.
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- it is assumed that this is after a 0x4e which has
;;;		  a zero as the last bit.
;;;		- the number is shifted three times to indicates the
;;;		  number of BITS (not bytes) to generate.
;;;		- must be called at (-8) and returns at (-9)
;;;		  (both on a zero cycle)
;;;		- BIG NOTE - assumes ARG0 <= 32
;;;*******************************************************************
DD0x00:
		rlf	ARG0		; (-4) Multiply by 2
		rlf	ARG0		; (-3)   by 4
		rlf	ARG0		; (-2)   by 8
		decf	ARG0		; (-1) leave one pulse for the end
	
DD0x00_1:	BitPulse		; (-0)
		Wait10			; (-13)
		decfsz	ARG0		; (-3)
		goto	DD0x00_1	; (-2)

		Wait1			; (-1)
		BitPulse		; (0)
	
		return			; (-13)


;;;*******************************************************************
;;; NAME:	DD0xa1S()
;;;
;;; DESCR:	Generate 3 of the special alignment 0xa1's that have a
;;;		missing transition between bits 4 and 5.
;;;
;;; ARGS:	ARG0 is the number of things to generate
;;;		SBWORK is used as scratch
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- always preceeded by the 0x00's, so the preceeding
;;;		  bit is a zero
;;;		- so the timing begins in the 1 domain, since it is
;;;		  preceeded by a zero, we must shift by 10
;;;		- last bit is a one, and is set as such
;;; NOTES:	- a1 = 1010,0001     -->  01 00 01 00 10 10 10 01
;;;		  with missing clock -->  01 00 01 00 10 00 10 01
;;;		- which xlates to -> align w/10 [P, 33, P, 23, P, 33, P, 23, P (13 to next pulse) ]
;;;		  where P = pulse, and the numbers are wait time
;;;		- assumes preceded by a bit 0
;;;		- make sure we align with our previous zero (ie - may have
;;; 			to wait 10)
;;;		- uses the two variables given for temporary storage
;;;		- this thing is ALWAYS followed by a 1 next (due to the
;;;		  fact that it is either a header or data block coming
;;;		  next in DD format)
;;;		- ARG0 has the number of these to generate (should be 3)
;;;		- call at (-9) from a one domain and returns at (0) in one domain
;;;		- the last bit pulse ISN'T DONE...the gap macro does it.
;;;*******************************************************************
		;; shifts to the one domain immediately
DD0xa1S:
		movlw	d'2'		; (-7)
		movwf	SBWORK		; (-6)

DD0xa1S_2:	Wait5			; (-5)
	
		BitPulse		; (-0)
		Wait23			; (-33)
		Wait10			; (-10) together a wait33

		BitPulse		; (-0)
		Wait15			; (-23)
		decfsz	SBWORK		; (-8)
		goto	DD0xa1S_2	; (-7)

		decf	ARG0		; (-6)
		skpnz			; (-5)
		goto	DD0xa1S_3	; (-4)

                bsf	STATUS,C	; (-3) mark that the last bit was a one (for later)
		Wait2			; (-2)
		BitPulse		; (0)
		Wait2			; (-13)

		movlw	0xff		; (-11) set the carry bit so heading out of
		addlw	0x01		; (-10)   DD0xa1S() it is right
	
		goto	DD0xa1S		; (-9)

DD0xa1S_3:	return			; (-2) aligned for next bit of 1


;;; ---------------------------------------------------------------------
;;; ---------------------------------------------------------------------
	END
